import QtQuick 2.10

Item {
    width: 320
    height: 200
    property string who : "nobody"

    Shortcut {
        sequence: "Esc"
        onActivated: who = "Shortcut"
    }

    TextEdit {
        objectName: "txt"
        x: 100
        text: "enter text"
        Keys.onShortcutOverride: (event) => {
            who = "TextEdit"
            event.accepted = (event.key === Qt.Key_Escape)
        }
    }

    Shortcut {
        sequence: "A"
        onActivated: who = "ShortcutA"
    }

    TextEdit {
        objectName: "testOverride"
        x: 100
        y: 100
        text: "enter text"
        Keys.onTabPressed: (event) => {
            who = "Superfluous" // Just for test and no intention to handle
        }
    }

    Rectangle {
        objectName: "rectangle"
        width: 90
        height: width
        focus: true
        color: focus ? "red" : "gray"
        Keys.onShortcutOverride: (event) => {
            who = "Rectangle"
            event.accepted = (event.key === Qt.Key_Escape)
        }
    }
}
